/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef BASETEXTURE_H
#define BASETEXTURE_H

#include <GL/glew.h>
#include "../content/Resource.h"

namespace Engine {
namespace Graphics {

class RenderDevice;

class BaseTexture : public Content::Resource
{
    public:
        enum TextureFormat {
            TRF_SRGB8 = GL_SRGB8,
            TRF_SRGB8_A8 = GL_SRGB8_ALPHA8,

            TRF_RGBA8 = GL_RGBA8,
            TRF_RG8 = GL_RG8,
            TRF_R8 = GL_R8,

            TRF_RGBA16 = GL_RGBA16,
            TRF_RG16 = GL_RG16,
            TRF_R16 = GL_R16,

            TRF_RGBA16F = GL_RGBA16F,
            TRF_RG16F = GL_RG16F,
            TRF_R16F = GL_R16F,

            TRF_RGBA32F = GL_RGBA32F,
            TRF_RG32F = GL_RG32F,
            TRF_R32F = GL_R32F,

            TRF_RGBA8I = GL_RGBA8I,
            TRF_RG8I = GL_RG8I,
            TRF_R8I = GL_R8I,

            TRF_RGBA16I = GL_RGBA16I,
            TRF_RG16I = GL_RG16I,
            TRF_R16I = GL_R16I,

            TRF_RGBA32I = GL_RGBA32I,
            TRF_RG32I = GL_RG32I,
            TRF_R32I = GL_R32I,

            TRF_RGBA8UI = GL_RGBA8UI,
            TRF_RG8UI = GL_RG8UI,
            TRF_R8UI = GL_R8UI,

            TRF_RGBA16UI = GL_RGBA16UI,
            TRF_RG16UI = GL_RG16UI,
            TRF_R16UI = GL_R16UI,

            TRF_RGBA32UI = GL_RGBA32UI,
            TRF_RG32UI = GL_RG32UI,
            TRF_R32UI = GL_R32UI,

            TRF_RGB10_A2 = GL_RGB10_A2,
            TRF_RGB10_A2UI = GL_RGB10_A2UI,

            TRF_RG11F_B10F = GL_R11F_G11F_B10F,

            TRF_D16 = GL_DEPTH_COMPONENT16,
            TRF_D24 = GL_DEPTH_COMPONENT24,
            TRF_D32F = GL_DEPTH_COMPONENT32F,

            TRF_D24_S8 = GL_DEPTH24_STENCIL8,
            TRF_D32F_S8 = GL_DEPTH32F_STENCIL8,


            TF_RG_SIGNED_RGTC = GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT,
            TF_R_SIGNED_RGTC = GL_COMPRESSED_SIGNED_RED_RGTC1_EXT,

            TF_RG_RGTC = GL_COMPRESSED_RED_GREEN_RGTC2_EXT,
            TF_R_RGTC = GL_COMPRESSED_RED_RGTC1_EXT,

            TF_RGB_DXT1 = GL_COMPRESSED_RGB_S3TC_DXT1_EXT,
            TF_RGBA_DXT1 = GL_COMPRESSED_RGBA_S3TC_DXT1_EXT,

            TF_RGBA_DXT5 = GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
        };

        static unsigned getSizePerBlock(TextureFormat format);
        static bool isBlockBasedFormat(TextureFormat format);


        BaseTexture(RenderDevice *renderDevice);
        virtual ~BaseTexture();

        inline unsigned getID() const { return m_textureID; }
        inline TextureFormat getTextureFormat() const { return m_format; }
    protected:
        RenderDevice *m_renderDevice;
        TextureFormat m_format;
        unsigned m_textureID;

        friend class RenderDevice;

};

}
}
#endif // BASETEXTURE_H
