/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef BUFFEROBJECT_H
#define BUFFEROBJECT_H

#include <GL/glew.h>
#include <GL/gl.h>

namespace Engine {
namespace Graphics {

class RenderDevice;

class BufferObject
{
    public:
        enum BufferType {
            BUFFER_TYPE_ARRAY = GL_ARRAY_BUFFER,
            BUFFER_TYPE_ELEMENT_ARRAY = GL_ELEMENT_ARRAY_BUFFER,
            //BUFFER_TYPE_SHADER_STORAGE_BUFFER = GL_SHADER_STORAGE_BUFFER,
            BUFFER_TYPE_UNIFORM_BUFFER = GL_UNIFORM_BUFFER
        };

        enum UsageType {
            USAGE_TYPE_STATIC_DRAW = GL_STATIC_DRAW,
            USAGE_TYPE_STATIC_READ = GL_STATIC_READ,
            USAGE_TYPE_STATIC_COPY = GL_STATIC_COPY,

            USAGE_TYPE_DYNAMIC_DRAW = GL_DYNAMIC_DRAW,
            USAGE_TYPE_DYNAMIC_READ = GL_DYNAMIC_READ,
            USAGE_TYPE_DYNAMIC_COPY = GL_DYNAMIC_COPY,

            USAGE_TYPE_STREAM_DRAW = GL_STREAM_DRAW,
            USAGE_TYPE_STREAM_READ = GL_STREAM_READ,
            USAGE_TYPE_STREAM_COPY = GL_STREAM_COPY
        };

        BufferObject(RenderDevice *device, BufferType type);
        ~BufferObject();

        void resize(unsigned size, UsageType usageType);

        void fillBuffer(unsigned offset, unsigned size, const void *data);
        void invalidateBuffer(unsigned offset, unsigned size);
        void invalidateBuffer();

        inline unsigned getID() const { return m_bufferId; }

        unsigned getSize() const { return m_allocatedSize; }
    protected:

        RenderDevice *m_renderDevice;
        unsigned m_bufferId;
        BufferType m_bufferType;
        UsageType m_usageType;
        unsigned m_allocatedSize;


        friend class RenderDevice;
    private:
        BufferObject(const BufferObject &other) { }
        const BufferObject &operator=(const BufferObject &other) { return *this; }
};

}
}

#endif // BUFFEROBJECT_H
