/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GLSLSHADER_H
#define GLSLSHADER_H

#include <GL/glew.h>
#include <string>

namespace Engine {
namespace Graphics {


class RenderDevice;

class GLSLShader
{
    public:
        enum Stage {
            STAGE_VERTEX_SHADER = GL_VERTEX_SHADER,
            STAGE_FRAGMENT_SHADER = GL_FRAGMENT_SHADER,
            STAGE_GEOMETRY_SHADER = GL_GEOMETRY_SHADER,
            STAGE_TESS_CTRL_SHADER = GL_TESS_CONTROL_SHADER,
            STAGE_TESS_EVAL_SHADER = GL_TESS_EVALUATION_SHADER
        };

        GLSLShader(RenderDevice *renderDevice, Stage stage);
        ~GLSLShader();

        inline unsigned getID() const { return m_shaderID; }

        bool compile(const char *code);
        std::string getLog();
    protected:
        unsigned m_shaderID;
};

}
}

#endif // GLSLSHADER_H
