/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MultiRenderTarget.h"

#include <iostream>

#include "Texture2D.h"
#include "RenderDevice.h"


namespace Engine {
namespace Graphics {

MultiRenderTarget::MultiRenderTarget(RenderDevice *renderDevice) : FrameBufferObject(renderDevice)
{
    m_width = m_height = 0;
}

MultiRenderTarget::~MultiRenderTarget()
{
    //dtor
}

void MultiRenderTarget::resize(unsigned width, unsigned height)
{
    m_width = width;
    m_height = height;
    for (unsigned i = 0; i < m_attachments.size(); i++)
        m_attachments[i].second->resize(m_width, m_height, 1, m_attachments[i].second->getTextureFormat());
}

void MultiRenderTarget::attach(AttachmentType attachmentType, Texture2D *texture)
{
    texture->resize(m_width, m_height, 1, texture->getTextureFormat());
    m_renderDevice->bindFramebufferObject(this);
    glFramebufferTexture2D(GL_FRAMEBUFFER, attachmentType, GL_TEXTURE_2D, texture->getID(), 0);

    for (unsigned i = 0; i < m_attachments.size(); i++)
        if (m_attachments[i].first == attachmentType) {
            m_attachments[i].second = texture;
            return;
        }

    m_attachments.push_back(std::make_pair(attachmentType, texture));
}


void MultiRenderTarget::checkCompleteness()
{
    m_renderDevice->bindFramebufferObject(this);

    GLenum status = glCheckFramebufferStatus(GL_FRAMEBUFFER);
    if (status != GL_FRAMEBUFFER_COMPLETE)
        std::cout << "Error: FBO incomplete: " << status << std::endl;
}


}
}
