/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TEXTURE2DARRAY_H
#define TEXTURE2DARRAY_H


#include "BaseTexture.h"

namespace Engine {
namespace Graphics {

class Texture2DArray : public BaseTexture
{
    public:
        Texture2DArray(RenderDevice *renderDevice);

        void resize(unsigned width, unsigned height, unsigned slices, unsigned levels, TextureFormat format);

        void uploadTextureLevel(unsigned slice, unsigned level, const void *data, unsigned size, bool compressed, TextureFormat sourceFormat);
        void uploadTextureLevelAllSlices(unsigned level, const void *data, unsigned size, bool compressed, TextureFormat sourceFormat);

        void setupFilter(unsigned mag, unsigned min);
        void setupWrapMode(unsigned wrapS, unsigned wrapT);

        inline unsigned getNumSlices() const { return m_slices; }
    protected:
        unsigned m_width, m_height, m_slices, m_levels;

};

}
}

#endif // TEXTURE2DARRAY_H
