DEBUG_OBJS    := $(addprefix ${DEBUG_OBJ_DIR}, ${SRCS:.cpp=.o} )
DEBUG_DEPS    := $(addprefix ${DEBUG_DEP_DIR}, ${SRCS:.cpp=.dep} )
DEBUG_XDEPS   := $(wildcard ${DEBUG_DEPS}) 

RELEASE_OBJS    := $(addprefix ${RELEASE_OBJ_DIR}, ${SRCS:.cpp=.o} )
RELEASE_DEPS    := $(addprefix ${RELEASE_DEP_DIR}, ${SRCS:.cpp=.dep} )
RELEASE_XDEPS   := $(wildcard ${RELEASE_DEPS}) 


.PHONY: all debug release clean
all:: ${RELEASE_TARGET} ${DEBUG_TARGET}

debug:: ${DEBUG_TARGET}

release:: ${RELEASE_TARGET}

print_config:
	@echo "Cuda installation located in ${CUDA_BASE_DIR}"
	@echo "Cuda cflags ${CUDA_CFLAGS}"
	@echo "Cuda nvcc cflags ${CUDA_NVCC_CFLAGS}"
	@echo "Image magick cflags ${IMAGE_MAGICK_CFLAGS}"
	@echo "Image magick lflags ${IMAGE_MAGICK_LFLAGS}"


ifneq (${RELEASE_XDEPS},) 
include ${RELEASE_XDEPS} 
endif 

ifneq (${DEBUG_XDEPS},) 
include ${DEBUG_XDEPS} 
endif 

${DEBUG_TARGET}: ${DEBUG_OBJS}
	@echo -e ${bash_green}Building static lib${bash_nocolor}
	@mkdir -p $(dir $@)
	@${AR} rs ${DEBUG_TARGET} ${DEBUG_OBJS}
	@${RANLIB} ${DEBUG_TARGET}

${DEBUG_OBJS}: ${DEBUG_OBJ_DIR}%.o: %.cpp ${DEBUG_DEP_DIR}%.dep 
	@echo -e ${bash_green}Compiling $<${bash_nocolor}
	@mkdir -p $(dir $@)
	@${CC} -o $@ -c $< ${DEBUG_CFLAGS}

${DEBUG_DEPS}: ${DEBUG_DEP_DIR}%.dep: %.cpp Makefile ${HELPER_MK_FILE}
	@echo -e ${bash_green}Building deps for $<${bash_nocolor}
	@mkdir -p $(dir $@)
	@${CC} ${DEBUG_CFLAGS} -MM $< > $@ 



${RELEASE_TARGET}: ${RELEASE_OBJS}
	@echo -e ${bash_green}Building static lib${bash_nocolor}
	@mkdir -p $(dir $@)
	@${AR} rs ${RELEASE_TARGET} ${RELEASE_OBJS}
	@${RANLIB} ${RELEASE_TARGET}

${RELEASE_OBJS}: ${RELEASE_OBJ_DIR}%.o: %.cpp ${RELEASE_DEP_DIR}%.dep 
	@echo -e ${bash_green}Compiling $<${bash_nocolor}
	@mkdir -p $(dir $@)
	@${CC} -o $@ -c $< ${RELEASE_CFLAGS}

${RELEASE_DEPS}: ${RELEASE_DEP_DIR}%.dep: %.cpp Makefile ${HELPER_MK_FILE}
	@echo -e ${bash_green}Building deps for $<${bash_nocolor}
	@mkdir -p $(dir $@)
	@${CC} ${RELEASE_CFLAGS} -MM $< > $@ 

clean::
	rm -f ${DEBUG_OBJS} ${DEBUG_DEPS} ${DEBUG_TARGET}
	rm -f ${RELEASE_OBJS} ${RELEASE_DEPS} ${RELEASE_TARGET}

