CC := g++
NVCC := nvcc
AR := ar
RANLIB := ranlib
MAKE := make

COMMON_FLAGS := -std=c++11 -march=corei7-avx -Wall

IMAGE_MAGICK_CFLAGS := $(shell pkg-config --cflags ImageMagick++)
IMAGE_MAGICK_LFLAGS := $(shell pkg-config --libs ImageMagick++)

############# locate cuda ################
CUDA_LIBCUDART_LOCATION := $(shell ldconfig -p | grep libcudart | awk '{print $$4}' | head -n 1 | head -c -1)
ifeq (${CUDA_LIBCUDART_LOCATION},)
$error("Cuda installation could not be found!")
endif
CUDA_LIBRARIES_DIR := $(shell dirname ${CUDA_LIBCUDART_LOCATION})
CUDA_BASE_DIR := $(shell dirname ${CUDA_LIBRARIES_DIR})
CUDA_INCLUDE_DIR := ${CUDA_BASE_DIR}/include
########## end of locate cuda #############

CUDA_NVCC_CFLAGS := -use_fast_math -O3 -gencode arch=compute_30,code=sm_30
CUDA_CFLAGS := -I${CUDA_INCLUDE_DIR}
CUDA_LFLAGS := -L${CUDA_LIBRARIES_DIR} -lcuda -lcudart


BOOST_CFLAGS := -DBOOST_SIGNALS_NO_DEPRECATION_WARNING
BOOST_LFLAGS := -lboost_filesystem -lboost_system -lboost_thread


TINYXML_CFLAGS :=
TINYXML_LFLAGS := -ltinyxml


DEBUG_CFLAG_ADDITIONS := -g -fno-omit-frame-pointer
RELEASE_CFLAG_ADDITIONS := -ffast-math -fexpensive-optimizations -O3 -DNDEBUG

DEBUG_LFLAG_ADDITIONS := 
RELEASE_LFLAG_ADDITIONS := -O3 -s



bash_red='\e[0;31m'
bash_green='\e[0;32m'
bash_yellow='\e[1;33m'
bash_nocolor='\e[0m'

