/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "InternalCameraCalibration.h"
#include <assert.h>

namespace SFM {

InternalCameraCalibration::InternalCameraCalibration(BundleAdjustment *ba,
        const LinAlg::Matrix4x4f &projectionMatrix,
        const BundleAdjustment::RadialDistortionParametrization &radialDistortion,
        float aspectRatio) :
        m_ba(ba), m_projectionMatrix(projectionMatrix), m_radialDistortion(radialDistortion), m_aspectRatio(aspectRatio)
{
    m_baIntCalibHandle = -1;
}

InternalCameraCalibration::~InternalCameraCalibration()
{
    if (m_baIntCalibHandle != (unsigned)-1)
        m_ba->removeIntCamCalib(m_baIntCalibHandle);
}

void InternalCameraCalibration::setRadialDistortion(const BundleAdjustment::RadialDistortionParametrization &radialDistortion)
{
    m_radialDistortion = radialDistortion;
    if (m_baIntCalibHandle != (unsigned)-1)
        m_ba->setInternalCalibRadialDistortion(m_baIntCalibHandle, m_radialDistortion);
}

void InternalCameraCalibration::activateBA()
{
    assert(m_baIntCalibHandle == (unsigned)-1);
    m_baIntCalibHandle = m_ba->addIntCamCalib();

    m_ba->setInternalCalibRadialDistortion(m_baIntCalibHandle, m_radialDistortion);
    m_ba->setInternalCalibProjectionMatrix(m_baIntCalibHandle, m_projectionMatrix);
}

void InternalCameraCalibration::readBackFromBA()
{
    assert(m_baIntCalibHandle != (unsigned)-1);

    m_projectionMatrix = m_ba->getInternalCalibProjectionMatrix(m_baIntCalibHandle);
    m_radialDistortion = m_ba->getInternalCalibRadialDistortion(m_baIntCalibHandle);

}



}
