/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INTERNALCAMERACALIBRATION_H
#define INTERNALCAMERACALIBRATION_H

#include "../tools/LinAlg.h"
#include "BundleAdjustment/BundleAdjustment.h"

namespace SFM {

/**
 * @brief Describes the internal calibration of a camera for the structure from motion pipeline.
 * @ingroup SFMBackend_Group
 */
class InternalCameraCalibration
{
    public:
        InternalCameraCalibration(BundleAdjustment *ba, const LinAlg::Matrix4x4f &projectionMatrix,
                                  const BundleAdjustment::RadialDistortionParametrization &radialDistortion,
                                  float aspectRatio);
        ~InternalCameraCalibration();

        inline const LinAlg::Matrix4x4f &getProjectionMatrix() const { return m_projectionMatrix; }
        inline const BundleAdjustment::RadialDistortionParametrization &getRadialDistortion() const { return m_radialDistortion; }
        void setRadialDistortion(const BundleAdjustment::RadialDistortionParametrization &radialDistortion);

        inline const float getAspectRatio() const { return m_aspectRatio; }

        inline BundleAdjustment::InternalCamCalibHandle getBAHandle() const { return m_baIntCalibHandle; }

        void activateBA();
        void readBackFromBA();

        bool activeInBA() const { return m_baIntCalibHandle!=(unsigned)-1; }

    protected:
        BundleAdjustment *m_ba;
        LinAlg::Matrix4x4f m_projectionMatrix;

        BundleAdjustment::RadialDistortionParametrization m_radialDistortion;
        float m_aspectRatio;

        BundleAdjustment::InternalCamCalibHandle m_baIntCalibHandle;

};

}

#endif // INTERNALCAMERACALIBRATION_H
