/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef FEATUREEXTRACTIONCONFIG_H
#define FEATUREEXTRACTIONCONFIG_H


namespace SFM {
namespace config {


/**
 * @brief Parameters of the feature extraction step
 *
 * @ingroup SFMBackend_Group
 */
struct FeatureExtractionConfig
{
    bool upsampleInitiallyOnce = false;
    /// Threshold on the difference of gaussians strength for feature point extraction. Lower values generate more feature points.
    float minimalDoGThreshold = 0.005f;
    /// Parameter that restricts how 'thin'/line like feature points can be.
    float maxElongation_rth = 10.0f;
    /// Maximum feature points per octave. Needed to reserve memory.
    unsigned maxPossibleFPLocations = 500000;
    /// Maximum feature points per image. Needed to reserve memory.
    unsigned maxFPs = 500000;
    /// SIFT operates on octaves. This limits the number of octaves to perform on.
    unsigned numOctaves = 6;
};

}
}

#endif // FEATUREEXTRACTIONCONFIG_H
