/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SFMCONFIG_H
#define SFMCONFIG_H

#include "BundleAdjustmentConfig.h"
#include "CudaConfig.h"
#include "FeatureExtractionConfig.h"
#include "FeatureMatchingConfig.h"
#include "SubsetSelectionConfig.h"


namespace SFM {

/**
 * @brief Structs containing parameters of the structure from motion process
 * @ingroup SFMBackend_Group
 */
namespace config {


/**
 * @brief All parameters of the structure from motion process
 * @ingroup SFMBackend_Group
 */
struct SfMConfig
{
    FeatureExtractionConfig featureExtractionConfig;
    FeatureMatchingConfig featureMatchingConfig;
    CudaConfig cudaConfig;
    BundleAdjustmentParameterConfig bundleAdjustmentParameterConfig;
    BundleAdjustmentStructureConfig bundleAdjustmentStructureConfig;
    SubsetSelectionConfig subsetSelectionConfig;

    /// Factor on the avg. reprojection error to determine the reprojection error threshold for identifying outliers among the active tracks
    float outlierRemovalActiveThreshFactor = 4.0f;
    /// Minimal reprojection error threshold for identifying outliers among the active tracks
    float outlierRemovalActiveThreshMinimum = 0.001f * 4.0f;

    /// Factor on the avg. reprojection error to determine the reprojection error threshold for identifying identify outliers among the semi-active tracks
    float outlierRemovalSemiActiveThreshFactor = 8.0f;
    /// Minimal reprojection error threshold for identifying outliers among the semi-active tracks
    float outlierRemovalSemiActiveThreshMinimum = 0.001f * 8.0f;

    /// Batch size for multithreaded structure-only bundle adjustment of the semi-active tracks
    unsigned baSemiActiveTracksBatchSize = 400;
    /// Number of BundleAdjustment <--> OutlierRemoval iterations
    unsigned numRemoveOutlierItertions = 10;

    /// Number of extra rounds to perform after the last camera was added to the reconstruction
    unsigned numExtraRounds = 1;
    /// Maximal number of rounds without adding a new camera before the reconstruction is aborted
    unsigned maxRoundsWithoutNewImage = 10;

    unsigned verbatimLevel = 0;
};

}
}

#endif // SFMCONFIG_H
