/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef IMAGEMIPCHAINBUILDER_H
#define IMAGEMIPCHAINBUILDER_H

#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"
#include "../cudaUtilities/CudaSurfaceReference.h"

#include <memory>

#include "../tools/RasterImage.h"

class ImageMipchainBuilder
{
    public:
        ImageMipchainBuilder();
        ~ImageMipchainBuilder();

        void buildMipChain(const RasterImage &source, CudaUtils::CudaMipmappedTexture &destination);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_convertRGBMImageKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_downsampleRGBMImageKernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_mipChainInputTexRef;
        std::unique_ptr<CudaUtils::CudaSurfaceReference> m_mipChainOutputSurfRef;
};

#endif // IMAGEMIPCHAINBUILDER_H
