/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INITIALPATCHGATHERER_H
#define INITIALPATCHGATHERER_H


#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"
#include "../cudaUtilities/CudaSurfaceReference.h"

#include <memory>

class InitialPatchGatherer
{
    public:
        InitialPatchGatherer();
        ~InitialPatchGatherer();

        struct PatchCandidate {
            float score;
            float angle;
            float lod;
            float x;
            float y;
            uint32_t data[16*16] __attribute__((aligned (16)));
            //LinAlg::Matrix2x2f covarMat;

            inline bool operator<(const PatchCandidate &other) const { return score < other.score; }
        };

        void gatherPatches(CudaUtils::CudaMipmappedTexture &image, std::vector<PatchCandidate> &candidates);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_findOrientedBlobsKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_nonMaximumSuppressKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_patchExtractionKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_computeSelfSimilaritiesKernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_sourceImageTexRef;
        std::unique_ptr<CudaUtils::CudaSurfaceReference> m_orientedBlobScoreSurfRef;

        std::unique_ptr<CudaUtils::CudaTextureReference> m_stage1OutputPyramidTexRef;


        CudaUtils::CudaMipmappedTexture m_orientedBlobScoreOutput;

        CudaUtils::CudaDeviceMemory m_patchCandidateArray;
        CudaUtils::CudaDeviceMemory m_patchesArray;




};

#endif // INITIALPATCHGATHERER_H
