/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INITIALPATCHOPTIMIZER_H
#define INITIALPATCHOPTIMIZER_H


#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"
#include "../cudaUtilities/CudaSurfaceReference.h"

#include <memory>


class InitialPatchOptimizer
{
    public:
        InitialPatchOptimizer();
        ~InitialPatchOptimizer();

        struct InitialTrack {
            float screenSize[2];
            LinAlg::Vector2f screenSpacePositions[2];
            float size;
            LinAlg::Vector3f worldSpacePosition;
            LinAlg::Matrix3x3f orientation;

            uint32_t data1[16*16] __attribute__((aligned (16)));
            uint32_t data2[16*16] __attribute__((aligned (16)));
        };

        void optimizePatches(CudaUtils::CudaMipmappedTexture &image1, CudaUtils::CudaMipmappedTexture &image2,
                             const LinAlg::Matrix4x4f &P1, const LinAlg::Matrix4x4f &P2, std::vector<InitialTrack> &tracks);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_optimizeKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_computeErrorsKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_extractProjectionsKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_extractPreWarpedProjectionsKernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_sourceImage1TexRef;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_sourceImage2TexRef;
        std::unique_ptr<CudaUtils::CudaConstantMemory> m_kernelConstantParams;
        std::unique_ptr<CudaUtils::CudaConstantMemory> m_kernelExtractionPreWarpMatrices;

        CudaUtils::CudaDeviceMemory m_trackData;
};

#endif // INITIALPATCHOPTIMIZER_H
