/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef NEWTRACKOBSERVATIONTESTER_H
#define NEWTRACKOBSERVATIONTESTER_H


#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"
#include "../cudaUtilities/CudaSurfaceReference.h"

#include <vector>
#include <memory>

class PatchAtlas;

class NewTrackObservationTester
{
    public:
        NewTrackObservationTester();
        ~NewTrackObservationTester();

        struct Track {
            LinAlg::Vector4f worldSpacePosition;
            LinAlg::Matrix3x3f orientation;
            float size;
            struct Observation {
                unsigned patchAtlasIndex;
                LinAlg::Vector2f screenSpaceOffset;
            };
            std::vector<Observation> observations;
        };

        struct NewObservation {
            unsigned trackIndex;

            unsigned patchAtlasIndex;
            LinAlg::Vector2f screenSpaceOffset;

            float error;
        };


        void test(std::vector<Track> &tracks, std::vector<NewObservation> &newObservations, PatchAtlas *patchAtlas);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_testKernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_patchAtlasTexRef;
        std::unique_ptr<CudaUtils::CudaConstantMemory> m_kernelPatchAtlasConstantParams;
        CudaUtils::CudaDeviceMemory m_trackData;
        CudaUtils::CudaDeviceMemory m_newObservationData;
        CudaUtils::CudaDeviceMemory m_patchAtlasData;
};


#endif // NEWTRACKOBSERVATIONTESTER_H
