/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PAIRWISEPATCHALIGNER_H
#define PAIRWISEPATCHALIGNER_H


#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"

#include <memory>

class PatchCache;

class PairwisePatchAligner
{
    public:
        PairwisePatchAligner();
        ~PairwisePatchAligner();

        struct AlignmentPair {
            unsigned templatePatchCacheSlot;
            unsigned alignmentPatchCacheSlot;

            LinAlg::Vector2f templateScreenSpacePosition;
            LinAlg::Matrix3x3f templateScreenToAlignmentScreen;

            float alignmentError;
        };

        void optimize(std::vector<AlignmentPair> &pairs, PatchCache *patchCache);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_alignmentKernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_patchAtlasTexRef;

        CudaUtils::CudaDeviceMemory m_jobData;
};

#endif // PAIRWISEPATCHALIGNER_H
