/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PATCHATLAS_H
#define PATCHATLAS_H

#include <memory>
#include <string.h>

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "PatchAtlasConstants.h"

class PatchAtlas
{
    public:
        PatchAtlas();
        ~PatchAtlas();

        CudaUtils::CudaMipmappedTexture *getAtlasTexture() { return m_atlasTexture.get(); }
        inline const PatchAtlasConstants &getConstants() const { return m_constants; }
        inline const std::vector<PatchAtlasPatchParams> &getPatchParams() const { return m_patchParams; }
        inline void setWorldToAtlasPatchMatrix(unsigned index, const LinAlg::Matrix4x4f &m) {
            memcpy(m_patchParams[index].worldToAtlasPatch, &m[0][0], 4*4*4);
        }
        void setWorldToAtlasPatchFromProjectionMatrix(unsigned index, const LinAlg::Matrix4x4f &P);
        void setSourceImageToAtlasPatchScaleOffset(unsigned index, float centerX, float centerY, float w, float h);

        unsigned allocatePatch();
        void freePatch(unsigned index);

        unsigned getNumPatchesInUse() const;
        void debugDumpLayer(unsigned layerIndex);
    protected:
        unsigned m_numPatches;
        std::vector<uint64_t> m_inUse;
        std::unique_ptr<CudaUtils::CudaMipmappedTexture> m_atlasTexture;
        std::unique_ptr<CudaUtils::CudaDeviceMemory> m_videoPatchParams;

        PatchAtlasConstants m_constants;
        std::vector<PatchAtlasPatchParams> m_patchParams;


};

#endif // PATCHATLAS_H
