/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _PATCH_ATLAS_H_
#define _PATCH_ATLAS_H_

#include <stdint.h>

struct PatchAtlasConstants {
    float halfTexelSize;
    float patchSize;

    enum {
        ATLAS_PATCH_SIZE = 64,
        ATLAS_MIP_LEVEL = 5
    };
} __attribute__((packed));

struct PatchAtlasPatchParams {
    uint8_t patchX;
    uint8_t patchY;
    uint8_t layer;
    uint8_t padding;
    float sourceImageToAtlasPatchScaleOffsetX[2];
    float sourceImageToAtlasPatchScaleOffsetY[2];
    float worldToAtlasPatch[4*4];
} __attribute__((packed));


#endif // _PATCH_ATLAS_H_

