/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _PATCHCACHETYPES_H_
#define _PATCHCACHETYPES_H_

enum {
    PATCH_CACHE_PATCH_SIZE = 64,
    PATCH_CACHE_PATCH_SQRSIZE = PATCH_CACHE_PATCH_SIZE*PATCH_CACHE_PATCH_SIZE,
    PATCH_CACHE_LAYER_SIZE = 2048,
    PATCH_CACHE_NUM_ROWS = PATCH_CACHE_LAYER_SIZE/PATCH_CACHE_PATCH_SIZE
};

struct PackedPatch
{
    float imageCenterX, imageCenterY;
    float imageTexelSizeX, imageTexelSizeY;

    float screenCenterX, screenCenterY;
    float screenTexelSizeX, screenTexelSizeY;

    enum { PACKED_PATCH_DATA_SIZE = PATCH_CACHE_PATCH_SQRSIZE };
    unsigned char data[PATCH_CACHE_PATCH_SQRSIZE];
};


#endif // _PATCHCACHETYPES_H_

