/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SOURCEIMAGETOPATCHATLASTRANSFER_H
#define SOURCEIMAGETOPATCHATLASTRANSFER_H


#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"
#include "../cudaUtilities/CudaSurfaceReference.h"

#include <vector>
#include <memory>

class PatchAtlas;

class SourceImageToPatchAtlasTransfer
{
    public:
        SourceImageToPatchAtlasTransfer();
        ~SourceImageToPatchAtlasTransfer();

        struct TransferData {
            float x;
            float y;
            float size;
            unsigned atlasIndex;
        };

        void transfer(CudaUtils::CudaMipmappedTexture &sourceImage, std::vector<TransferData> &transferData, PatchAtlas *atlas);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_normalizationParameterKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_kernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_sourceImageTexRef;
        std::unique_ptr<CudaUtils::CudaConstantMemory> m_kernelConstantParams;
        std::unique_ptr<CudaUtils::CudaSurfaceReference> m_outputSurfRef;
        CudaUtils::CudaDeviceMemory m_videoData;
        CudaUtils::CudaDeviceMemory m_normalizationParameters;
};

#endif // SOURCEIMAGETOPATCHATLASTRANSFER_H
