/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TRACKALIGNMENTOPTIMIZER_H
#define TRACKALIGNMENTOPTIMIZER_H


#include "../cudaUtilities/CudaCodeModule.h"
#include "../cudaUtilities/CudaKernel.h"

#include "../cudaUtilities/CudaTextureMemory.h"
#include "../cudaUtilities/CudaDeviceMemory.h"

#include "../cudaUtilities/CudaTextureReference.h"
#include "../cudaUtilities/CudaSurfaceReference.h"

#include <vector>
#include <memory>

class PatchAtlas;

class TrackAlignmentOptimizer
{
    public:
        TrackAlignmentOptimizer();
        ~TrackAlignmentOptimizer();

        struct Track {
            LinAlg::Vector4f worldSpacePosition;
            LinAlg::Matrix3x3f orientation;
            float size;
            struct Observation {
                unsigned patchAtlasIndex;
                float screenSize;
                LinAlg::Vector2f screenSpaceOffset;
            };
            std::vector<Observation> observations;
            float remainingError;
            uint32_t preWarpedPatches[16*16*11];
        };

        void optimize(std::vector<Track> &tracks, PatchAtlas *patchAtlas, unsigned numIterations);
    protected:
        CudaUtils::CudaCodeModule m_codeModule;
        std::unique_ptr<CudaUtils::CudaKernel> m_alignmentKernel;
        std::unique_ptr<CudaUtils::CudaKernel> m_extractionKernel;
        std::unique_ptr<CudaUtils::CudaTextureReference> m_patchAtlasTexRef;
        std::unique_ptr<CudaUtils::CudaConstantMemory> m_kernelPatchAtlasConstantParams;
        std::unique_ptr<CudaUtils::CudaConstantMemory> m_kernelPreWarpConstantParams;
        CudaUtils::CudaDeviceMemory m_trackData;
        CudaUtils::CudaDeviceMemory m_indexData;
        CudaUtils::CudaDeviceMemory m_patchAtlasData;
};

#endif // TRACKALIGNMENTOPTIMIZER_H
