/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DENSERECONSTRUCTION_H_INCLUDED
#define DENSERECONSTRUCTION_H_INCLUDED

struct ReprojectionMatrix {
    float rowMajor[4*4];
};

struct ImageVote {
    unsigned short pixelX, pixelY;
    float rcpDepth;
    float vote;
};

struct GenerateVotesKernelParams
{
    unsigned offsetX, offsetY;
    unsigned imageWidth;
    unsigned imageHeight;
    float rcpImageWidth, imageCenterX;
    float rcpImageHeight, imageCenterY;

    unsigned maxVotes;
    unsigned *numVotes;
    ImageVote *votes;

    unsigned numImages;
    unsigned refImage;
    ReprojectionMatrix *reprojectionMatrices;

    float voteThresh;
    float depthStepSize;
};

struct ConvertRGBImageKernelParams
{
    unsigned width;
    unsigned height;

    unsigned *source;
    unsigned layer;
};

#endif // DENSERECONSTRUCTION_H_INCLUDED
