/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "PackedPatchToPatchCache.cuh"
#include "cudaKernelUtils/WarpLoadStore.hpp"


surface<void, cudaSurfaceType2DLayered> PatchCache;

extern "C" __global__ void PackedPatchToPatchCacheKernel(PackedPatchToPatchCacheKernelParams kernelParams)
{
    unsigned jobIdx = blockIdx.x;

    __shared__ PackedPatchTransferMetaData metaData;

    if (threadIdx.y == 0) {
        cuUtils::warpCopy<PackedPatchTransferMetaData>(&metaData, &kernelParams.metaData[jobIdx]);
    }

    __syncthreads();



    // todo: inverse WHT transform

    for (unsigned y = threadIdx.y; y < 64; y +=32)
        for (unsigned x = threadIdx.x; x < 64; x +=32) {
            unsigned char lum = kernelParams.patchData[jobIdx*64*64+y*64+x];
            surf2DLayeredwrite(lum, PatchCache, (metaData.dstOffsetX + x)*1, (metaData.dstOffsetY + y), metaData.dstLayer);
        }
}
