/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef COMPUTEPAIRWISEPATCHALIGNMENT_H_INCLUDED
#define COMPUTEPAIRWISEPATCHALIGNMENT_H_INCLUDED

#include "../cudaInterface/PatchAtlasConstants.h"

const unsigned PairwisePatchAlignmentMaxIterations = 20;
const unsigned PairwisePatchAlignmentPatchSize = 24;
const unsigned PairwisePatchAlignmentPatchSqrSize = PairwisePatchAlignmentPatchSize*PairwisePatchAlignmentPatchSize;

struct PairwisePatchAlignmentJob
{
    float templatePatchAtlasLocation[2];
    float templatePatchAtlasSize;
    unsigned templatePatchAtlasLayer;

    unsigned alignmentPatchAtlasLayer;
    float alignment[6];
    float alignmentError;
};

//#define COMPUTEPAIRWISEPATCHALIGNMENT_ENABLE_DEBUG_OUTPUT

#ifdef COMPUTEPAIRWISEPATCHALIGNMENT_ENABLE_DEBUG_OUTPUT

struct PairwisePatchAlignmentDebugOutput
{
   // float errors[PairwisePatchAlignmentMaxIterations];
    float templateImage[PairwisePatchAlignmentPatchSize*PairwisePatchAlignmentPatchSize];
    float alignedImage[PairwisePatchAlignmentPatchSize*PairwisePatchAlignmentPatchSize];
    float unalignedImage[PairwisePatchAlignmentPatchSize*PairwisePatchAlignmentPatchSize];
};


#endif


struct PairwisePatchAlignmentKernelParams
{
    PairwisePatchAlignmentJob *jobs;
    unsigned numJobs;
//    PatchAtlasPatchParams *patchAtlasParams;
#ifdef COMPUTEPAIRWISEPATCHALIGNMENT_ENABLE_DEBUG_OUTPUT
    PairwisePatchAlignmentDebugOutput *debugOutput;
#endif
};




#endif // COMPUTEPAIRWISEPATCHALIGNMENT_H_INCLUDED
