/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CUUTILHELPERS_HPP_INCLUDED
#define CUUTILHELPERS_HPP_INCLUDED

namespace cuUtils {

enum { WARP_SIZE = 32 };

template<unsigned param>
struct Log2RoundDown
{
    enum {
        value = Log2RoundDown<(param >> 1)>::value+1
    };
};

template<>
struct Log2RoundDown<1>
{
    enum {
        value = 0
    };
};


template<unsigned param>
struct NextPowerOfTwoRoundUp
{
    private:
        enum {
            log2RD = Log2RoundDown<param>::value,
            nextPowerOfTwoRoundDown = 1 << log2RD
        };
    public:
        enum {
            value = (param == nextPowerOfTwoRoundDown)?nextPowerOfTwoRoundDown:(nextPowerOfTwoRoundDown << 1)
        };
};

__device__ inline unsigned getWarpIdInBlock2D() { return (threadIdx.x + threadIdx.y * blockDim.x) / WARP_SIZE; }


}


#endif // CUUTILHELPERS_HPP_INCLUDED
