/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _INITIALTRACKOPTIMIZER_H_
#define _INITIALTRACKOPTIMIZER_H_

#include <stdint.h>

struct TrackData
{
    float size;
    float lod[2];
    float surfaceToWorld[3*4];
    float epipolarOffsetHalf;
};

struct ConstantParams {
    unsigned numTracks;
    float P1norm[4*4];
    float P2norm[4*4];
};


struct ExtractProjectionsKernelParams {
    TrackData *trackData;
    uint32_t *dst;
};


#endif // _INITIALTRACKOPTIMIZER_H_
