/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _NEWOBSERVATIONTEST_H_
#define _NEWOBSERVATIONTEST_H_

//#define NEWOBS_OUTPUT_DEBUG_PAIRS

struct TrackHead
{
    float trackSurfaceToWorld[3*4];
    float size;
    uint32_t numObservations;
    float remainingError;
    uint32_t padding0;
};

struct TrackObservation
{
    uint32_t patchAtlasIndex;
    uint32_t padding0;
    float screenSpaceOffset[2];
};

struct NewObservationCandidate
{
    TrackHead *track;

    uint32_t patchAtlasIndex;
    float screenSpaceOffset[2];
    float error;
    uint32_t padding0;
};

struct NewObservationTestParams
{
    unsigned blockOffset;
    NewObservationCandidate *newCandidates;
    PatchAtlasPatchParams *patchAtlasPatchParams;
    unsigned char *trackData;
#ifdef NEWOBS_OUTPUT_DEBUG_PAIRS
    uint32_t *debugOutput;
#endif
};

#ifdef NEWOBS_OUTPUT_DEBUG_PAIRS
const unsigned maxDebugOutputPairs = 500;
#endif

#endif // _NEWOBSERVATIONTEST_H_
