/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _TRACKOPTIMIZATION_H_
#define _TRACKOPTIMIZATION_H_

//#define TRACK_ALIGN_OUTPUT_DEBUG_DATA

struct TrackHead
{
    float trackSurfaceToWorld[3*4];
    float size;
    uint32_t numObservations;
    float remainingError;
} __attribute__((packed));

struct TrackObservation
{
    uint32_t patchAtlasIndex;
    float screenSize;
    float screenSpaceOffset[2];
} __attribute__((packed));

struct OptimizeTracksKernalParams
{
    unsigned blockOffset;
    unsigned char **index;
    PatchAtlasPatchParams *patchAtlasPatchParams;
#ifdef TRACK_ALIGN_OUTPUT_DEBUG_DATA
    uint32_t *debugOutput;
#endif
    unsigned numIterations;
};

struct ExtractProjectionsKernelParams {
    unsigned blockOffset;
    unsigned char **index;
    PatchAtlasPatchParams *patchAtlasPatchParams;
    uint32_t *dst;
};


#endif // _TRACKOPTIMIZATION_H_

