/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
 * @file
 * @author Andreas Ley
 */
#ifndef CUDAFENCE_H
#define CUDAFENCE_H

#include <cuda_runtime_api.h>
#include "CudaStream.h"

/** @addtogroup Codebase_Group
 *  @{
 */

class CudaFence
{
    public:
        CudaFence();
        ~CudaFence();
        void insertIntoStream(const CudaStream &stream);
        void insertIntoMainStream();
        bool query();
        void waitFor();
    protected:
        CudaFence(const CudaFence&) : m_event(0) { }
        const CudaFence& operator=(const CudaFence&) { return *this; }

        cudaEvent_t m_event;
};

/// @}

#endif // CUDAFENCE_H
