/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "ChunkedSOA.h"
#include <malloc.h>
#include <stdexcept>

ChunkedSOA::ChunkedSOA(unsigned numMembers, const unsigned *memberSizes)
{
    m_members.resize(numMembers);
    m_chunkSize = 0;
    for (unsigned i = 0; i < numMembers; i++) {
        m_members[i].offset = m_chunkSize;
        m_members[i].stride = memberSizes[i];
        m_members[i].size = m_members[i].stride * CHUNK_SIZE;
        m_chunkSize += m_members[i].size;
    }

    m_size = 0;
}

ChunkedSOA::~ChunkedSOA()
{
    //dtor
}

ChunkedSOA::Chunk::Chunk(unsigned size)
{
    ptr = (unsigned char*) memalign(16, size);
    if (ptr == NULL)
        throw std::runtime_error("Out of memory!");
}

ChunkedSOA::Chunk::~Chunk()
{
    free(ptr);
}



void ChunkedSOA::clear()
{
    m_size = 0;
}

void ChunkedSOA::resize(unsigned numElements)
{
    reserve(numElements);
    m_size = numElements;
}

void ChunkedSOA::reserve(unsigned numElements)
{
    unsigned numChunks = (numElements + CHUNK_SIZE-1) >> CHUNK_SIZE_LOG2;
    if (numChunks > m_chunks.size()) {
        unsigned offset = m_chunks.size();
        m_chunks.resize(numChunks);
        for (unsigned i = offset; i < m_chunks.size(); i++) {
            m_chunks[i] = std::unique_ptr<Chunk>(new Chunk(m_chunkSize));
        }
    }
}

