/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "LinAlg.h"
#include <math.h>
#include <iostream>
#include <cmath>

namespace LinAlg {

const Vector3f crossf(const Vector3f &v1, const Vector3f &v2)
{
    return cross<float>(v1, v2);
}
float crossf(const Vector2f &v1, const Vector2f &v2)
{
    return cross<float>(v1, v2);
}

Matrix3x3f Rotation2D(float angle)
{
    Matrix3x3f m;
    m[0][0] = std::cos(angle);
    m[1][0] = std::sin(angle);
    m[0][1] = -std::sin(angle);
    m[1][1] = std::cos(angle);
    return m;
}

Matrix3x3f Translation2D(const Vector2f &v)
{
    Matrix3x3f m;
    m[0][2] = v[0];
    m[1][2] = v[1];
    return m;
}

Matrix3x3f Scale2D(const Vector2f &v)
{
    Matrix3x3f m;
    m[0][0] = v[0];
    m[1][1] = v[1];
    return m;
}

Matrix4x4f Translation3D(const Vector3f &v)
{
    Matrix4x4f m;
    m[0][3] = v[0];
    m[1][3] = v[1];
    m[2][3] = v[2];
    return m;
}


Matrix4x4f RotateX(float angle)
{
    Matrix4x4f m;
    m[1][1] = std::cos(angle);
    m[2][1] = std::sin(angle);
    m[1][2] = -std::sin(angle);
    m[2][2] = cos(angle);
    return m;
}

Matrix4x4f RotateY(float angle)
{
    Matrix4x4f m;
    m[0][0] = std::cos(angle);
    m[2][0] = std::sin(angle);
    m[0][2] = -std::sin(angle);
    m[2][2] = std::cos(angle);
    return m;
}

Matrix4x4f RotateZ(float angle)
{
    Matrix4x4f m;
    m[0][0] = std::cos(angle);
    m[1][0] = std::sin(angle);
    m[0][1] = -std::sin(angle);
    m[1][1] = std::cos(angle);
    return m;
}


Matrix4x4f InvertOrientationMatrix(const Matrix4x4f &mat)
{
    Matrix4x4f result;
    result = mat.T();
    result[3][0] = 0.0;
    result[3][1] = 0.0;
    result[3][2] = 0.0;

    Vector4f offset = Fill(mat[0][3], mat[1][3], mat[2][3], mat[3][3]);
    offset = result * offset;
    result[0][3] = -offset[0];
    result[1][3] = -offset[1];
    result[2][3] = -offset[2];
    return result;
}


};
