/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file
 * @author Andreas Ley
 */
#include "SpectatorCamera.h"

SpectatorCamera::SpectatorCamera()
{
    m_rotation[1] = M_PI;
}

SpectatorCamera::~SpectatorCamera()
{
    //dtor
}

void SpectatorCamera::turn(float dx, float dy)
{
    m_rotation[0] += dx;
    m_rotation[1] += dy;
}

void SpectatorCamera::accelerate(const LinAlg::Vector3f &eyeSpaceAcceleration, float dt)
{
    m_speed += (m_eyeToWorldSpace * eyeSpaceAcceleration.AddHom(0.0f)).StripHom() * dt;
}

void SpectatorCamera::operate(float dt)
{
    m_position += m_speed * dt;
    m_speed *= powf(0.2f, dt);
}

void SpectatorCamera::updateMatrices()
{
    m_worldToEyeSpace = LinAlg::RotateX(-m_rotation[0]) *  LinAlg::RotateY(-m_rotation[1]) * LinAlg::Translation3D(m_position.negated());
    m_eyeToWorldSpace = LinAlg::Translation3D(m_position) *  LinAlg::RotateY(m_rotation[1]) * LinAlg::RotateX(m_rotation[0]);
}
