/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file
 * @author Andreas Ley
 */
#ifndef SPECTATORCAMERA_H
#define SPECTATORCAMERA_H

#include "LinAlg.h"

/** @addtogroup Codebase_Group
 *  @{
 */

/**
 * @brief Implements the GUI's camera which allows to fly through the scene.
 */
class SpectatorCamera
{
    public:
        SpectatorCamera();
        ~SpectatorCamera();

        void turn(float dx, float dy);
        void accelerate(const LinAlg::Vector3f &eyeSpaceAcceleration, float dt);
        void operate(float dt);
        void updateMatrices();


        inline const LinAlg::Matrix4x4f &getWorldToEyeSpaceMatrix() const { return m_worldToEyeSpace; }

        inline const LinAlg::Vector3f &getCameraPosition() const { return m_position; }
        inline LinAlg::Vector3f &getCameraPosition() { return m_position; }
    protected:

        LinAlg::Vector2f m_rotation;
        LinAlg::Vector3f m_position;
        LinAlg::Vector3f m_speed;
        LinAlg::Matrix4x4f m_worldToEyeSpace;
        LinAlg::Matrix4x4f m_eyeToWorldSpace;
};

/// @}

#endif // SPECTATORCAMERA_H
