/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef STACKALLOCATOR_H
#define STACKALLOCATOR_H

#include <vector>

/** @addtogroup Codebase_Group
 *  @{
 */

class StackAllocator
{
    public:
        StackAllocator();
        ~StackAllocator();

        inline void reset() { m_currentChunk = 0; m_currentByte = 0; }
        void *allocate(unsigned size);
        void *allocateAligned16(unsigned size);
    protected:
        unsigned m_currentChunk;
        unsigned m_currentByte;

        enum {
            MIN_CHUNK_SIZE = 4096,
            MIN_CHUNK_SIZE_MASK = MIN_CHUNK_SIZE
        };

        struct Chunk {
            unsigned char *data;
            unsigned size;
        };
        std::vector<Chunk> m_chunks;

        void addChunk(unsigned minSize);
};

/// @}

#endif // STACKALLOCATOR_H
