/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PMVSEXPORTER_H
#define PMVSEXPORTER_H

#include <boost/filesystem.hpp>

namespace SFM {
class SFM;

namespace Utilities {

/**
 * @brief Creates the directories and files necessary for a dense reconstruction with PMVS2.
 * @details In addition to outputting the camera parameters in the correct format and supplying the
 * options.txt file, the images are also copied and renamed into the correct folder and, if distortion
 * estimation was enabled, resampled to free them of of their radial distortion.
 * @ingroup SFMUtilities_Group
 */
void exportPMVS(const boost::filesystem::path &destinationPath, SFM &sfm);

}
}


#endif // PMVSEXPORTER_H
