/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "BufferObject.h"
#include "RenderDevice.h"
#include <assert.h>

namespace Engine {
namespace Graphics {


BufferObject::BufferObject(RenderDevice *device, BufferType type) : m_renderDevice(device), m_bufferType(type)
{
    glGenBuffers(1, &m_bufferId);
    m_allocatedSize = 0;
}

BufferObject::~BufferObject()
{
    glDeleteBuffers(1, &m_bufferId);
}


void BufferObject::resize(unsigned size, UsageType usageType)
{
    m_renderDevice->bindBuffer(this);
    glBufferData(m_bufferType, size, NULL, m_usageType = usageType);
    m_allocatedSize = size;
}

void BufferObject::fillBuffer(unsigned offset, unsigned size, const void *data)
{
    m_renderDevice->bindBuffer(this);
    assert(offset+size <= m_allocatedSize);
    glBufferSubData(m_bufferType, offset, size, data);

}

void BufferObject::invalidateBuffer(unsigned offset, unsigned size)
{
    if ((offset == 0) && (size == m_allocatedSize))
        invalidateBuffer();
    else
        assert(false && "Not implemented yet!");
        //glInvalidateBufferSubData(m_bufferId, offset, size);
}

void BufferObject::invalidateBuffer()
{

//    glInvalidateBufferDataARB(m_bufferId);
    m_renderDevice->bindBuffer(this);
    glBufferData(m_bufferType, m_allocatedSize, NULL, m_usageType);

}

}
}
