/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef FRAMEBUFFEROBJECT_H
#define FRAMEBUFFEROBJECT_H

#include <GL/glew.h>

namespace Engine {
namespace Graphics {

class RenderDevice;

class FrameBufferObject
{
    public:
        enum AttachmentType {
            ATTACHMENT_COLOR0 = GL_COLOR_ATTACHMENT0,
            ATTACHMENT_COLOR1 = GL_COLOR_ATTACHMENT1,
            ATTACHMENT_COLOR2 = GL_COLOR_ATTACHMENT2,
            ATTACHMENT_COLOR3 = GL_COLOR_ATTACHMENT3,
            ATTACHMENT_COLOR4 = GL_COLOR_ATTACHMENT4,
            ATTACHMENT_COLOR5 = GL_COLOR_ATTACHMENT5,
            ATTACHMENT_COLOR6 = GL_COLOR_ATTACHMENT6,
            ATTACHMENT_COLOR7 = GL_COLOR_ATTACHMENT7,
            ATTACHMENT_DEPTH = GL_DEPTH_ATTACHMENT,
            ATTACHMENT_STENCIL = GL_STENCIL_ATTACHMENT,
            ATTACHMENT_DEPTH_STENCIL = GL_DEPTH_STENCIL_ATTACHMENT
        };

        FrameBufferObject(RenderDevice *renderDevice);
        ~FrameBufferObject();
    protected:
        RenderDevice *m_renderDevice;
        unsigned m_objectID;

        friend class RenderDevice;
    private:
};

}
}

#endif // FRAMEBUFFEROBJECT_H
