/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "GLSLShader.h"


namespace Engine {
namespace Graphics {

GLSLShader::GLSLShader(RenderDevice *renderDevice, Stage stage)
{
    m_shaderID = glCreateShader(stage);
}

GLSLShader::~GLSLShader()
{
    glDeleteShader(m_shaderID);
}

bool GLSLShader::compile(const char *code)
{
    glShaderSource(m_shaderID, 1, &code, NULL);
    glCompileShader(m_shaderID);
    int success;
    glGetShaderiv(m_shaderID, GL_COMPILE_STATUS, &success);
    return success == GL_TRUE;
}

std::string GLSLShader::getLog()
{
    int logLength;
    glGetShaderiv(m_shaderID, GL_INFO_LOG_LENGTH, &logLength);
    if (logLength <= 0)
        return "";
    char buff[logLength];
    glGetShaderInfoLog(m_shaderID, logLength, NULL, buff);
    return buff;
}


}
}
