/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MeshBufferLayout.h"

#include <stdexcept>
#include <boost/lexical_cast.hpp>

namespace Engine {
namespace Graphics {


unsigned MeshBufferLayout::AttributeType::dataTypeSize(DataType dataType)
{
    switch (dataType) {
        case DATA_TYPE_SI8: return 1;
        case DATA_TYPE_UI8: return 1;

        case DATA_TYPE_SI16: return 2;
        case DATA_TYPE_UI16: return 2;

        case DATA_TYPE_F16: return 2;

        case DATA_TYPE_F32: return 4;
    };
    return 0;
}


MeshBufferLayout::AttributeType MeshBufferLayout::stringToAttributeType(const std::string &str)
{
    AttributeType result;

    if (str.length() < 3)
        throw std::runtime_error("Bad attribute data type specification!");

    result.numComponents = boost::lexical_cast<unsigned int>(std::string(str.begin(), str.begin()+1));
    char x = *(str.begin()+1);
    if (x != 'x')
        throw std::runtime_error("Bad attribute data type specification!");


    std::string type(str.begin()+2, str.end());
    if (type == "SI8")
        result.dataType = AttributeType::DATA_TYPE_SI8; else
    if (type == "UI8")
        result.dataType = AttributeType::DATA_TYPE_UI8; else
    if (type == "SI16")
        result.dataType = AttributeType::DATA_TYPE_SI16; else
    if (type == "UI16")
        result.dataType = AttributeType::DATA_TYPE_UI16; else
    if (type == "F16")
        result.dataType = AttributeType::DATA_TYPE_F16; else
    if (type == "F32")
        result.dataType = AttributeType::DATA_TYPE_F32; else
        throw std::runtime_error("Bad attribute data type specification!");

    result.normalized = true;


    return result;
}

unsigned MeshBufferLayout::getAttribIndex(const std::string &name) const
{
    for (unsigned i = 0; i < attribs.size(); i++)
        if (attribs[i].name == name)
            return i;

    return -1;
}



}
}
