/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MESHBUFFERLAYOUT_H
#define MESHBUFFERLAYOUT_H

#include <string>
#include <GL/glew.h>
#include <vector>

namespace Engine {
namespace Graphics {


struct MeshBufferLayout {
    struct AttributeType {
        unsigned numComponents;
        enum DataType {
            DATA_TYPE_SI8 = GL_BYTE,
            DATA_TYPE_UI8 = GL_UNSIGNED_BYTE,

            DATA_TYPE_SI16 = GL_SHORT,
            DATA_TYPE_UI16 = GL_UNSIGNED_SHORT,

            DATA_TYPE_F16 = GL_HALF_FLOAT,

            DATA_TYPE_F32 = GL_FLOAT
        };
        static unsigned dataTypeSize(DataType dataType);
        DataType dataType;
        bool normalized;
    };

    static AttributeType stringToAttributeType(const std::string &str);


    std::string name;
    unsigned stride;
    struct Attrib {
        std::string name;
        unsigned offset;
        AttributeType dataType;
    };
    std::vector<Attrib> attribs;
    unsigned getAttribIndex(const std::string &name) const;
};

struct MeshIndexRange {
    std::string name;
    unsigned offset;
    unsigned count;
};


}
}

#endif // MESHBUFFERLAYOUT_H
