/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CUDASIFT_CUH_INCLUDED
#define CUDASIFT_CUH_INCLUDED

const unsigned CUDA_SIFT_NUM_OCTAVE_SUBSTEPS = 3;

//#define CudaSift_EXTRACT_PATCH_DATA

struct CudaSiftDebugExtractHalfFloatFromLayeredArrayKernelParams {
    unsigned width;
    unsigned height;
    unsigned layer;
    float *dst;
};

struct CudaSiftConvertRGBMImageKernelParams {
    unsigned width;
    unsigned height;
    float rcpWidth;
    float rcpHeight;
};


struct CudaSiftGaussianFilterKernelParams {
    unsigned dstWidth;
    unsigned dstHeight;
    float rcpDstWidth;
    float rcpDstHeight;
    unsigned sourceLayer;
    unsigned destinationLayer;
    unsigned DoGDestinationLayer;
};

struct CudaSiftDownsampleKernelParams {
    unsigned dstWidth;
    unsigned dstHeight;
    unsigned sourceLayer;
    unsigned destinationLayer;
};


struct CudaSiftPossibleFeaturePointLocation {
    float x, y;
    unsigned layer;
};

struct CudaSiftLocatePossibleFeaturePointsKernelParams {
    unsigned width;
    unsigned height;
    float rcpWidth;
    float rcpHeight;

    float minimalDoGThreshold;

    unsigned *atomicCounter;
    unsigned maxFeatures;
    CudaSiftPossibleFeaturePointLocation *featurePoints;
};



struct CudaSiftFeaturePoint {
    float x,y;
    float scale;
    float angle;
    unsigned layer;
    float octave;
    unsigned descriptor[32];

    float locationPrecision;

#ifdef CudaSift_EXTRACT_PATCH_DATA
    int patchX;
    int patchY;
    unsigned patchOctave;
    unsigned char patch[64*64];
#endif
};

struct CudaSiftExtractFeaturePointsKernelParams {
    unsigned width;
    unsigned height;
    float rcpWidth;
    float rcpHeight;

    float octave;

    float maxElongation_Rth;

    unsigned numPossibleLocations;
    CudaSiftPossibleFeaturePointLocation *possibleLocations;

    unsigned *atomicCounter;
    unsigned maxFeatures;
    CudaSiftFeaturePoint *featurePoints;
};


#endif // CUDASIFT_CUH_INCLUDED
