/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef IMAGERESAMPLING_CUH_INCLUDED
#define IMAGERESAMPLING_CUH_INCLUDED


struct HomographyImageResamplingKernelParams {
    float srcWidth;
    float srcHeight;
    unsigned width;
    unsigned height;
    float homography[3*3]; // includes rcpWidth and rcpHeight scales
    float LODbias;
};


struct UndistortRadialPolynomial234KernelParams {
    unsigned width;
    unsigned height;

    float imageCenterX;
    float imageCenterY;

    float rcpFac;
    float fac;

    float kappa[3];
};

#endif // IMAGERESAMPLING_CUH_INCLUDED

