/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CUDATEXTUREREFERENCE_H
#define CUDATEXTUREREFERENCE_H


#include <cuda.h>

namespace CudaUtils {

class BaseCudaTextureMemory;
class CudaMipmappedTexture;

class CudaTextureReference
{
    public:
        CudaTextureReference(CUtexref handle);
        ~CudaTextureReference();

        inline CUtexref getHandle() { return m_handle; }

        enum FilterMode {
            FILTER_MODE_NEAREST = CU_TR_FILTER_MODE_POINT,
            FILTER_MODE_LINEAR = CU_TR_FILTER_MODE_LINEAR
        };

        void setTexelFilterMode(FilterMode filterMode);
        void setMipmapFilterMode(FilterMode filterMode);
        void setMinMaxMipLevel(float minMipLevel, float maxMipLevel);

        void setCoordinateNormalization(bool normalize);

        void bindTexture(BaseCudaTextureMemory *texMemory);
        void bindMipmappedTexture(CudaMipmappedTexture *texMemory);
    protected:
        CUtexref m_handle;
};

}

#endif // CUDATEXTUREREFERENCE_H
