/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _MISC_HPP_
#define _MISC_HPP_

#include <stdint.h>

/** @addtogroup Codebase_Group
 *  @{
 */

template<typename T>
void swapRemoveSingle(std::vector<T> &vec, const T &value)
{
    for (unsigned i = 0; i < vec.size(); i++) {
        if (vec[i] == value) {
            if (i+1 < vec.size())
                std::swap(vec[i], vec[vec.size()-1]);
            vec.resize(vec.size()-1);
            return;
        }
    }
}

static inline uint32_t ilog2(const uint32_t x) {
  uint32_t y;
  asm ( "\tbsr %1, %0\n"
      : "=r"(y)
      : "r" (x)
  );
  return y;
}

/// @}

#endif // _MISC_HPP_
