/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <boost/signal.hpp>
#include <tools/RefCountPtr.hpp>
#include <tools/misc.hpp>

namespace Engine {
namespace Content {

class Resource
{
    public:
        Resource();
        virtual ~Resource();

        inline void incReferences() { __sync_fetch_and_add(&m_numReferences, 1); }
        inline void decReferences() { __sync_fetch_and_sub(&m_numReferences, 1); }
        inline bool childrenReadyToUse() const { return m_numChildResourcesNotReady == 0; }
        inline unsigned numChildrenNotReady() const { return m_numChildResourcesNotReady; }
        inline bool readyToUse() const { return m_thisReadyToUse && childrenReadyToUse(); }
        void setReady();
        void setNotReady();
/*
        inline boost::signals::connection registerReadyStateChangedCallback(const boost::function<void(Resource*)> &callback) { return m_readyStateChangedSignal.connect(callback); }
        inline void deregisterReadyStateChangedCallback(const boost::signals::connection &callback) { callback.disconnect(); }
*/
        void addChildResource(Resource *resource);
        void removeChildResource(Resource *resource);
        void removeAllChildResources();
    protected:
        virtual void onAllChildResourcesReady();
        virtual void onNotAllChildResourceReady();

        virtual void becomeReady();
        virtual void becomeNotReady();
    private:
        volatile unsigned m_numReferences;
        unsigned m_numChildResourcesNotReady;

        void childResourceBecameReady();
        void childResourceBecameNotReady();

        bool m_thisReadyToUse;
/*
        typedef boost::signal<void(Resource*)> SignalType;
        SignalType m_readyStateChangedSignal;
*/
        std::vector<Resource*> m_parentResources;
        std::vector<RefCountPtr<Resource> > m_childResources;


        void checkCounter();

};

}
}

#endif // RESOURCE_H
