/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "BaseTexture.h"


namespace Engine {
namespace Graphics {


unsigned BaseTexture::getSizePerBlock(TextureFormat format)
{
    switch (format) {
        case TRF_RGBA32F:
        case TRF_RGBA32I:
        case TRF_RGBA32UI:
            return 16;

        case TRF_RGBA16:
        case TRF_RGBA16F:
        case TRF_RG32F:
        case TRF_RGBA16I:
        case TRF_RG32I:
        case TRF_RGBA16UI:
        case TRF_RG32UI:
            return 8;

        case TRF_SRGB8:
        case TRF_SRGB8_A8:
        case TRF_RGBA8:
        case TRF_RG16:
        case TRF_RG16F:
        case TRF_R32F:
        case TRF_RGBA8I:
        case TRF_RG16I:
        case TRF_R32I:
        case TRF_RGBA8UI:
        case TRF_RG16UI:
        case TRF_R32UI:
        case TRF_RGB10_A2:
        case TRF_RGB10_A2UI:
        case TRF_RG11F_B10F:
        case TRF_D24:
        case TRF_D32F:
        case TRF_D24_S8:
            return 4;

        case TRF_RG8:
        case TRF_R16:
        case TRF_R16F:
        case TRF_RG8I:
        case TRF_R16I:
        case TRF_RG8UI:
        case TRF_R16UI:
        case TRF_D16:
            return 2;

        case TRF_R8:
        case TRF_R8I:
        case TRF_R8UI:
            return 1;



        case TF_RG_SIGNED_RGTC:
        case TF_RG_RGTC:
        case TF_RGBA_DXT5:
            return 16;

        case TF_R_SIGNED_RGTC:
        case TF_R_RGTC:
        case TF_RGB_DXT1:
        case TF_RGBA_DXT1:
            return 8;

        default:
            return 0;
    };
}

bool BaseTexture::isBlockBasedFormat(TextureFormat format)
{
    switch (format) {
        case TF_RG_SIGNED_RGTC:
        case TF_RG_RGTC:
        case TF_RGBA_DXT5:
        case TF_R_SIGNED_RGTC:
        case TF_R_RGTC:
        case TF_RGB_DXT1:
        case TF_RGBA_DXT1:
            return true;
        default:
            return false;
    };
}



BaseTexture::BaseTexture(RenderDevice *renderDevice) : m_renderDevice(renderDevice)
{
    glGenTextures(1, &m_textureID);
}

BaseTexture::~BaseTexture()
{
    glDeleteTextures(1, &m_textureID);
}


}
}
