/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GLSLPROGRAM_H
#define GLSLPROGRAM_H

#include <string>
#include <vector>

#include "GLSLUniformBlockLayout.h"
#include "../content/Resource.h"

namespace Engine {
namespace Graphics {

class RenderDevice;
class GLSLShader;

class GLSLProgram : public Content::Resource
{
    public:
        GLSLProgram(RenderDevice *renderDevice);
        ~GLSLProgram();

        void attach(GLSLShader *shader);
        bool link();
        std::string getLog();

        void clearProgram();

        unsigned getUniformLocation(const char *name);
        unsigned getUniformBlockIndex(const char *name);

        void bindUniformBlockToSlot(unsigned index, unsigned slot);

        void getUniformBlockLayout(UniformBlockLayout &layout);
    protected:
        unsigned m_programID;

        friend class RenderDevice;
};

}
}

#endif // GLSLPROGRAM_H
