/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GLSLUNIFORMBLOCKLAYOUT_H
#define GLSLUNIFORMBLOCKLAYOUT_H

#include <string>
#include <vector>

namespace Engine {
namespace Graphics {

struct UniformBlockLayout {
    struct Entry {
        const char *m_name;
        bool m_valid;
        //int m_type;
        int m_offset;
        int m_numElements;
        int m_matrixStride;
    };
    const char *m_name;
    std::vector<Entry> m_entries;
    int m_blockSize;

    void prepare(const char *blockName, const char **names, unsigned count);
};

}
}

#endif // GLSLUNIFORMBLOCKLAYOUT_H
