/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MESH_H
#define MESH_H

#include <vector>
#include <string>
#include <GL/glew.h>
#include "MeshBufferLayout.h"
#include "../content/Resource.h"

namespace Engine {
namespace Graphics {

class RenderDevice;
class BufferObject;

class Mesh : public Content::Resource
{
    public:
        Mesh(RenderDevice *renderDevice);
        ~Mesh();

        void setupVertexBuffer(unsigned numBuffer, MeshBufferLayout *layouts);
        void fillVertexBuffer(unsigned bufferIndex, unsigned size, const void *data);

        void setupIndexData(unsigned numRanges, MeshIndexRange *ranges, unsigned bufferDataType, unsigned bufferSize, const void *bufferData);

        struct AttachedAttribBuffer {
            BufferObject *m_vertexBuffer;

            MeshBufferLayout m_layout;
        };

        unsigned getAttribBufferIndex(const std::string &name) const;
        inline const std::vector<AttachedAttribBuffer> &getAttribBuffers() const { return m_attachedAttribBuffers; }

        inline unsigned getIndexDataType() const { return m_indexDataType; }
        inline BufferObject *getIndexBuffer() const { return m_indexBuffer; }
        inline const std::vector<MeshIndexRange> &getIndexRanges() const { return m_indexRanges; }
        unsigned getIndexRangeIndex(const std::string &name) const;
    protected:
        RenderDevice *m_renderDevice;

        std::vector<AttachedAttribBuffer> m_attachedAttribBuffers;

        unsigned m_indexDataType;
        BufferObject *m_indexBuffer;
        std::vector<MeshIndexRange> m_indexRanges;

        friend class RenderDevice;
};

}
}

#endif // MESH_H
