/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef RENDERDEVICE_H
#define RENDERDEVICE_H

#include <stdint.h>

#include <GL/glew.h>

namespace Engine {
namespace Platform {
    class RenderContextInterface;
}

namespace Graphics {

class Texture1D;
class Texture2D;
class Texture2DArray;
class FrameBufferObject;
class BufferObject;
class GLSLProgram;
class Mesh;
class VertexArrayObject;
class RenderCommandBuffer;

class RenderDevice
{
    public:
        RenderDevice();
        ~RenderDevice();

        void switchRenderContext(Platform::RenderContextInterface *renderContext);


        void bindTexture(Texture2D *texture);
        void bindTexture(Texture2D *texture, unsigned samplerIndex);

        void bindTexture2DArray(Texture2DArray *texture);
        void bindTexture2DArray(Texture2DArray *texture, unsigned samplerIndex);

        void bindTexture1D(Texture1D *texture);
        void bindTexture1D(Texture1D *texture, unsigned samplerIndex);

        void bindFramebufferObject(FrameBufferObject *fbo);
        void bindDefaultFramebufferObject();
        void setDrawBuffers(unsigned count, const unsigned *attachments);
        void bindBuffer(BufferObject *buffer);
        void bindProgram(GLSLProgram *program);
        void bindUniformBufferToSlot(BufferObject *buffer, unsigned slot, unsigned offset = 0, unsigned size = -1);

        void bindVertexArrayObject(const VertexArrayObject *vao);

        enum PrimitiveType {
            PRIMITIVE_TYPE_POINTS = GL_POINTS,
            PRIMITIVE_TYPE_TRIANGLES = GL_TRIANGLES,
            PRIMITIVE_TYPE_QUADS = GL_QUADS
        };

        void renderIndices(const VertexArrayObject *vao, PrimitiveType primitiveType, unsigned indexDataType, unsigned offset, unsigned count);
        void renderVertices(const VertexArrayObject *vao, PrimitiveType primitiveType, unsigned offset, unsigned count);


     //   void executeRenderCommandBuffer(const RenderCommandBuffer &commandBuffer, unsigned pass);
    protected:
        Platform::RenderContextInterface *m_renderContext;


        struct State {
            unsigned boundVAO;
            unsigned boundTextures[8];
            unsigned boundFBO;
            unsigned boundProgram;
        };

        State m_renderDeviceState;
};

}
}

#endif // RENDERDEVICE_H
